/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.AbstractModulePanel;
import dioscuri.config.Emulator;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class BootPanel
extends AbstractModulePanel {
    final Emulator.Architecture.Modules.Bios bios;
    final String[] choices = new String[]{"Floppy Drive", "Hard Drive", "None"};
    final JComboBox boot0 = new JComboBox<String>(this.choices);
    final JComboBox boot1 = new JComboBox<String>(this.choices);
    final JComboBox boot2 = new JComboBox<String>(this.choices);
    final JCheckBox floppyCheckDisabled = new JCheckBox();

    BootPanel(GUI gUI, Emulator emulator) {
        super(gUI, emulator);
        this.bios = emulator.getArchitecture().getModules().getBios().get(0);
        super.setLayout(new GridLayout(0, 3, 5, 5));
        this.boot0.setSelectedItem(this.bios.getBootdrives().getBootdrive0());
        this.boot1.setSelectedItem(this.bios.getBootdrives().getBootdrive1());
        this.boot2.setSelectedItem(this.bios.getBootdrives().getBootdrive2());
        this.floppyCheckDisabled.setSelected(this.bios.isFloppycheckdisabled());
        super.add(new JLabel("Boot drive 1"));
        super.add(this.boot0);
        super.add(new JLabel());
        super.add(new JLabel("Boot drive 2"));
        super.add(this.boot1);
        super.add(new JLabel());
        super.add(new JLabel("Boot drive 3"));
        super.add(this.boot2);
        super.add(new JLabel());
        super.add(new JLabel("Floppy check disabled"));
        super.add(this.floppyCheckDisabled);
        super.add(new JLabel());
    }

    @Override
    void save() throws Exception {
        this.bios.getBootdrives().setBootdrive0(this.boot0.getSelectedItem().toString());
        this.bios.getBootdrives().setBootdrive1(this.boot1.getSelectedItem().toString());
        this.bios.getBootdrives().setBootdrive2(this.boot2.getSelectedItem().toString());
        this.bios.setFloppycheckdisabled(this.floppyCheckDisabled.isSelected());
    }
}

